#include "GLOBAL.H"


//----- UART0.C -----//
extern void UART_Send_Status( BYTE );


void Reboot_Mcu( BYTE Cmd )
{
	 ISPCR = Cmd;
}


void Initial_Mcu( void )
{ if( PCON & 0x10 )
  { PCON &= ~0x10;
    Reboot_Mcu( REBOOT_TO_AP );
  }
	
  TR0 = SET;                                     // Enable Timer0
  ET0 = SET;                                     // Enable Timer0 interrupt
  TR1 = SET;                                     // Enable Timer1 for UART
  ES = SET;                                      // Enable Uart0 interrupt
  EA  = SET;                                     // Enable All interrupt gate
  
  UART_Send_Status( OK );                       // MCU Ready for data transfer
}